/ * 
Early test program used for developing with PLX SDK.  Not used in driver
at this stage, but included for possible future debugging.  DR 11/9/01
*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#define PCI_CODE
#define LITTLE_ENDIAN

#include <assert.h>
#include <stdio.h>
#include <conio.h>
#include "PlxApi.h"
#include "Reg9050.h"

void main(void)
{
	HANDLE          hDevice;
	RETURN_CODE     rc;
	U32		ret;
	DEVICE_LOCATION Device;
	DEVICE_LOCATION *pDevice = &Device;
	U32		BufferDest;
	U32		RegValue, bar0, bar3;

	U32  DeviceNum;

	// Note: modify to scan for VT cards only
	pDevice->BusNumber  = (U32)-1;
	pDevice->SlotNumber = (U32)-1;
	pDevice->VendorId   = 0x10b5l; // Voicetronix
	pDevice->DeviceId   = 0x9050l; // PLX
	strcpy((char*)pDevice->SerialNumber, "");

	DeviceNum = FIND_AMOUNT_MATCHED;
	rc = PlxPciDeviceFind(pDevice, &DeviceNum);
	assert(rc == ApiSuccess);

	if (DeviceNum < 1) {
		assert(0);
	}

	// Note: modify to support multiple cards
	DeviceNum = 0;
	PlxPciDeviceFind(pDevice, &DeviceNum);
	rc = PlxPciDeviceOpen(&Device, &hDevice);
	assert(rc == ApiSuccess);

	// swap BAR0 and BAR3 addresses to ensure we have a bit7=0 address in
	// BAR0 (BAR3 is then unused)
	bar3 = PlxPciConfigRegisterRead(
			pDevice->BusNumber, 
			pDevice->SlotNumber,
			CFG_BAR3,
			&rc
			);
	bar0 = PlxPciConfigRegisterRead(
			pDevice->BusNumber, 
			pDevice->SlotNumber,
			CFG_BAR0,
			&rc
			);
	assert(rc == ApiSuccess);

	printf("BAR0 = 0x%x\n", bar0);
	printf("BAR3 = 0x%x\n", bar3);

	VIRTUAL_ADDRESSES Va;
	rc = PlxPciBaseAddressesGet(hDevice,&Va);
	assert(rc == ApiSuccess);
	printf("BAR 0 VA: 0x%08x\n", Va.Va0);
	printf("BAR 1 VA: 0x%08x\n", Va.Va1);
	printf("BAR 2 VA: 0x%08x\n", Va.Va2);
	printf("BAR 3 VA: 0x%08x\n", Va.Va3);
	printf("BAR 4 VA: 0x%08x\n", Va.Va4);
	printf("BAR 5 VA: 0x%08x\n", Va.Va5);
	printf("EROM VA : 0x%08x\n", Va.VaRom);

#ifdef TMP
	if (bar0 & 0x80) {
		rc = PlxPciConfigRegisterWrite(
				pDevice->BusNumber, 
				pDevice->SlotNumber,
				CFG_BAR0,
				&bar3
				);
		assert(rc == ApiSuccess);

		rc = PlxPciConfigRegisterWrite(
				pDevice->BusNumber, 
				pDevice->SlotNumber,
				CFG_BAR3,
				&bar0
				);

		assert(rc == ApiSuccess);
	}
#endif
		rc = PlxPciConfigRegisterWrite(
				pDevice->BusNumber, 
				pDevice->SlotNumber,
				CFG_BAR0,
				&bar3
				);
		assert(rc == ApiSuccess);

	// swap user-space addresses
	Va.Va0 = Va.Va3;

	// All PLX devices local registers are accessible through BAR 0
	// Read a Local register of the PLX chip
	U32 ctrl;
	if (Va.Va0 != (U32)-1 && Va.Va0 != 0) {
		ctrl = *(U32*)(Va.Va0 + 0x50); // Read register at offset 0x50
	}
	printf("ctrl = 0x%x\n",ctrl);
	ctrl &= ~(1<<2);
	//ctrl |= (1<<2);
	*(U32*)(Va.Va0 + 0x50) = ctrl;
	ctrl = *(U32*)(Va.Va0 + 0x50);
	printf("ctrl = 0x%x\n",ctrl);

#define N 0x10000
	U16 bufwr[N], bufrd[N];
	int i;

	for(i=0; i<N; i++) {
		bufwr[i] = i;
	}

#ifdef T
	// make sure memory is valid
	assert((Va.Va2 != (U32)-1) && (Va.Va2 != 0));
	memcpy((void*)Va.Va2, bufwr, sizeof(bufwr));
	//*(U16*)(Va.Va2 + 0x50) = 0xff; // Read register at offset 0x50
	memcpy(bufrd, (void*)Va.Va2, sizeof(bufwr));
	// check OK
	for(i=0; i<N; i++) {
		if (bufwr[i] != bufrd[i]) {
			printf("[%04x%x]: wr: 0x%04x rd: 0x%04x\n", i, bufwr[i], bufrd[i]);
		}
	}
#endif	
#define T1
#ifdef T1
	// make sure memory is valid
	assert((Va.Va3 != (U32)-1) && (Va.Va3 != 0));

	U16 *p = (U16*)Va.Va2;
	U32 offset = 0x1;
	//*(U16*)(Va.Va2 + 0) = bufwr[0];
//	*(p+offset) = bufwr[offset];
//	bufrd[offset] = *(p+offset);
	//bufrd[0] = *(U16*)(Va.Va2 + 0);

	*(p+offset) = bufwr[offset];
//	memcpy(p+offset, &bufwr[offset], 1*sizeof(short));
	memcpy(&bufrd[offset], p+offset, 1*sizeof(short));
//	bufrd[offset] = *(p+offset);

	i = offset; 
	printf("[0x%04x]: wr: 0x%04x rd: 0x%04x\n", i, bufwr[i], bufrd[i]);
#endif
}
